<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
    <title>Schematronvalidatie van PRPM_IN907020NL02 - Get Applications of an AssignedEntity Query</title>
    <ns uri="urn:hl7-org:v3" prefix="hl7"/>
    <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
    <include href="coreschematron/xml.sch"/>
    
    <include href="coreschematron/transmission-wrapper.sch"/>
    <include href="coreschematron/controlAct-wrapper.sch"/>
    
    <pattern is-a="transmission-wrapper" id="PRPM_IN907020NL02-wrapper">
        <param name="element" value="hl7:PRPM_IN907020NL02"/>
    </pattern>
    
    <pattern is-a="controlAct-wrapper" id="PRPM_IN907020NL02-controlAct">
        <param name="element" value="hl7:PRPM_IN907020NL02/hl7:ControlActProcess"/>
    </pattern>
    
    <pattern>
        <!-- profileId -->
        <rule context="hl7:PRPM_IN907020NL02/hl7:profileId">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.3.11.1' and @extension='810'"
                >In de transmission wrapper moet het element profileId worden gevuld met de waarde '810'</assert>
        </rule>
        <rule context="hl7:PRPM_IN907020NL02/hl7:acceptAckCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='NE'">In de transmission wrapper moet het veld acceptAckCode worden gevuld met waarde 'NE'.</assert>
        </rule>
        <rule context="hl7:PRPM_IN907020NL02/hl7:attentionLine">
            <assert role="warning" test="not(.)">Het gebruik van attentionLine wordt nog niet gespecificeerd in deze interactie.</assert>
        </rule>
    </pattern>
    
    <pattern>
        <!-- sender -->
        <rule context="hl7:PRPM_IN907020NL02/hl7:sender/hl7:device/hl7:id">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and not(@extension='1')"
                >De zender van deze interactie moet een AORTA applicatie zijn, en kan niet de ZIM zijn</assert>
        </rule>
        <!-- receiver -->
        <rule context="hl7:PRPM_IN907020NL02/hl7:receiver/hl7:device/hl7:id">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and @extension='1'"
                >De ontvanger van deze interactie moet een AORTA applicatie zijn, en moet de ZIM zijn</assert>
        </rule>
    </pattern>
     
    <pattern>
        <title>queryByParameter</title>
        <rule context="hl7:queryByParameter">
            <assert role="error" test="hl7:assignedEntityId or hl7:interactionId or hl7:qualifiedApplicationRoleCode"
                >tenminste één van de parameters assignedEntityId, interactionId of qualifiedApplicationRoleCode moet een waarde bevatten</assert>
        </rule>
        <rule context="hl7:queryByParameter/hl7:responseModalityCode">
            <extends rule="CS"/>
            <assert test="@code='R'">responseModalityCode moet vaste waarde 'R' hebben.</assert>
        </rule>
        <rule context="hl7:queryByParameter/hl7:assignedEntityId">
            <assert role="error" test="count(hl7:value)=1"
                ><name/>/value mag slechts één maal voorkomen.</assert>
        </rule>
        <rule context="hl7:queryByParameter/hl7:assignedEntityId/hl7:value">
            <extends rule="II"/>
            <assert role="warning" test="@root='2.16.528.1.1007.3.3' or (@root='2.16.840.1.113883.2.4.3.11' and @extension='7') or @root='2.16.840.1.113883.2.4.3.11.25' or @root='2.16.840.1.113883.2.4.3.11.10'"
                ><name path=".."/>/<name/> is onbekend (@root='<value-of select="@root"/>' @extension='<value-of select="@extension"/>'). Verwachte waarden zijn '2.16.528.1.1007.3.3' (URA), '2.16.840.1.113883.2.4.3.11' / '7' (Klantenloket), '2.16.840.1.113883.2.4.3.11.25' (GBO/GBP), '2.16.840.1.113883.2.4.3.11.10' (organisatiedelen)</assert>
        </rule>
        
        <rule context="hl7:queryByParameter/hl7:interactionId">
            <assert role="error" test="count(hl7:value)=1"
                ><name/>/value mag slechts één maal voorkomen.</assert>
        </rule>
        <rule context="hl7:queryByParameter/hl7:interactionId/hl7:value">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.1.6'"
                >interactionId/value/@root '2.16.840.1.113883.1.6' bevatten</assert>
        </rule>
        
        <rule context="hl7:queryByParameter/hl7:qualifiedApplicationRoleCode">
            <assert role="error" test="count(hl7:value)=1"
                ><name/>/value mag slechts één maal voorkomen.</assert>
        </rule>
        <rule context="hl7:queryByParameter/hl7:qualifiedApplicationRoleCode/hl7:value">
            <extends rule="CV"/>
            <assert role="error" test="@codeSystem='2.16.840.1.113883.2.4.3.11.3'"
                >qualifiedApplicationRoleCode/value/@codeSystem moet '2.16.840.1.113883.2.4.3.11.3' bevatten</assert>
        </rule>
        
    </pattern>
</schema>
